/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
/// ' Microsoft Content Management Server - Sample Code 
/// '
/// ' This sample code is provided "AS IS" with no warranties, and confers no rights. 
/// ' You assume all risk for your use.  2002 Microsoft Corporation. All rights reserved.
/// '
/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	
using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Web.UI.HtmlControls;
//Array reference for toolbox attributes
using System.Drawing;
//Array reference for array of Mcms objects
using System.Collections;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
//Add reference to the Mcms API
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;

namespace McmsSpsWebControlLibrary
{
	/// <summary>	
	/// 
	/// 
	/// <summary>
	/// Summary description for McmsSummary.
	///	This class implements a 'summary' page control to show Mcms objects in a collection. 
	/// </summary>
	[Designer(typeof(McmsSpsWebControlLibrary.Design.McmsSummaryDesigner)),
	ToolboxBitmapAttribute(typeof(McmsSummary), "MCMSToolBoxImage.bmp"),
	ToolboxData("<{0}:McmsSummary runat=server></{0}:McmsSummary>")]
	public class McmsSummary : System.Web.UI.WebControls.WebControl,INamingContainer
	{
		#region Public constructors
		public McmsSummary(): base()
		{
			//constructor logic 
			phname = "Title";

			string SeparatorString = " :: ";
			// Write a line to the Listener
			System.Diagnostics.Trace.WriteLine(System.DateTime.Now + SeparatorString + "Control" + SeparatorString + "Summary Control" + SeparatorString + "This is the constructor for the Summary Control.");
			// Record your output
			System.Diagnostics.Trace.Flush();
		}
		#endregion Public constructors

		#region Private member declarations
		private string text;
		//User defined properties 
		private string designText;
		private string cssClass;
		private string hidePageName;
		private string summaryChannel;
		//Limit characters to show from summary
		private int characters;
		
		//Select list for object name format
		public enum enumMcmsObjectNameOptions{Name, DisplayName};
		private string phname;
		private enumMcmsObjectNameOptions enumMcmsObjectName;
		#endregion Private member declarations
		
		#region Properties
		/// <summary>
		///		Default text property.
		/// </summary>
		/// 
		[Bindable(true), 
		Category("Appearance"), 
		DefaultValue("")] 
		public string Text 
		{
			get
			{
				return text;
			}

			set
			{
				text = value;
			}
		}

		/// <summary>
		///		The text that appears in the control in design view.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Text that appears in design view."),
		Category("Summary"),
		DefaultValue("Mcms Summary")]
		public string DesignText
		{
			get { return designText; }
			set { designText = value; }
		}
		//Allow user to change the value of property - in design view
		bool ShouldSerializeDesignText(){return true;}

		/// <summary>
		///		The object name used in the summary.
		///		Options: DisplayName, Name
		/// </summary>
		/// 		
		[Description("The name type used in the summary. Options are 'DisplayName' and 'Name'."),
		Category("Summary"),]
		public enumMcmsObjectNameOptions McmsObjectName
		{
			get { return enumMcmsObjectName; }
			set { enumMcmsObjectName = value; }
		}			
		//Allow user to change the value of property - in design view
		bool ShouldSerializeMcmsObjectName(){return true;}

		/// <summary>
		///		The optional placeholder object name used to show some content.
		///		Options: Text property which matched the placeholder name
		/// </summary>
		/// 		
		[Description("The placeholder name used to show content."),
		Category("Summary"),
		DefaultValue("Title")]
		public string McmsPhName
		{
			get { return phname; }
			set { phname = value; }
		}			
		//Allow user to change the value of property - in design view
		bool ShouldSerializeMcmsPhName(){return true;}

		/// <summary>
		///		The CSS style class for the control - both runtime and design.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Default CSS Style for the control."),
		Category("Appearance")]
		public override string CssClass
		{
			get { return cssClass; }
			set { cssClass = value; }
		}
		//Allow user to change the value of property - in design view
		bool ShouldSerializeCssClass(){return true;}

		/// <summary>
		///		Option to hide a certain page (by name).
		/// </summary>
		/// 		
		[Description("Optional hidden page name."),
		Category("Summary"),]
		public string HiddenPage
		{
			get { return hidePageName; }
			set { hidePageName = value; }
		}	
		//Allow user to change the value of property - in design view
		bool ShouldSerializeHiddenPage(){return true;}

		/// <summary>
		///		Numbers of charecters to show from summary placeholder.
		/// </summary>
		/// 		
		[Description("Summary character limit."),
		Category("Summary"),]
		public int CharactersToShow
		{
			get { return characters; }
			set { characters = value; }
		}	
		//Allow user to change the value of property - in design view
		bool ShouldSerializeCharactersToShow(){return true;}
		
		/// <summary>
		///		The Channel to summarize.
		/// </summary>
		/// 		
		[Description("Channel to summarize. Blank equals current"),
		Category("Summary"),]
		public string SummaryChannel
		{
			get { return summaryChannel; }
			set { summaryChannel = value; }
		}			
		//Allow user to change the value of property - in design view
		bool ShouldSerializeSummaryChannel(){return true;}
		#endregion Properties

		#region Private functions
		/// <summary>
		/// Function to create array of channel objects for the breadcrumb trail.
		/// </summary>
		public ArrayList SummaryArray(Channel chChannel, ArrayList arSummaryArray)
		{
			//Instantiate Mcms HTML Context
			CmsHttpContext CMSContext = CmsHttpContext.Current;

			//Error handling for null channel
			if(chChannel.Equals(null))
			{
				return arSummaryArray; //Early return
			}

			if(chChannel.Postings.Count>0)
			{
				//Add the objects to the array
				foreach(Posting pPosting in chChannel.Postings)
				{
					//Filter out a user defined page name
					if (pPosting.Name != HiddenPage)
					{
						arSummaryArray.Add(pPosting);
					}
				}
			}
			return(arSummaryArray);
		} // Close SummaryArray

		/// <summary>
		///		Create table controls for sumamry list.
		/// </summary>
		protected override void CreateChildControls()
		{
			// Call base class
			base.CreateChildControls();
			
			// Code to create a Table
			System.Web.UI.WebControls.Table	tblSummary = new System.Web.UI.WebControls.Table();
			
			// Populate the table with the summary info
			PopulateSummaryTable(tblSummary);
			
			// Add table to the Controls collection so it gets rendered
			Controls.Add(tblSummary);

		} //Close child controls

		/// <summary>
		/// Function to populate the table control used to present data.
		/// </summary>
		private Table PopulateSummaryTable(Table table)
		{
			//Instantiate Mcms AutosessionHTMLContext
			CmsHttpContext CMSContext = CmsHttpContext.Current;
			
			if(CssClass != null)
			{
				//Use the user defined style sheet class
				try
				{
					table.CssClass = CssClass;
				}
				catch
				{
					return table; //Early return
				}
			}

			//Define a row and cell
			System.Web.UI.WebControls.TableRow	row;
			System.Web.UI.WebControls.TableCell	cell;			
			//Create an anchor object
			HtmlAnchor navLink;
			//Channel to use for the control
			Channel objNavChannel;

			//Set channel to use in summary - blank = current channel
			if(SummaryChannel == null)
			{
				objNavChannel = CMSContext.Channel;
			}
			else
			{
				objNavChannel = (Channel)CMSContext.Searches.GetByPath(SummaryChannel);
			}

			//Error check for null Channel
			if(objNavChannel.Equals(null))
			{
				return table; //Early return
			}

			//Create the array for Mcms objects
			ArrayList arMcmsObjects = new ArrayList();
			//Call function to create array of breadcrumb channels
			arMcmsObjects = SummaryArray(objNavChannel, arMcmsObjects);
			//Reverse the array so that the objects are in the right order
			arMcmsObjects.Reverse();

			if(arMcmsObjects.Count>0)
			{
				//Loop through array and create row of links to channels
				foreach(Posting objMcmsObject in arMcmsObjects)
				{
					//Create a row for each link
					row = new System.Web.UI.WebControls.TableRow();
					table.Rows.Add(row);			
					//Prepare Channel anchor link
					navLink = new HtmlAnchor();

					//Add user defined option for object name (DisplayName or Name)
					if(McmsObjectName.ToString() == "Name")
					{ 
						navLink.InnerHtml = HttpUtility.HtmlEncode(objMcmsObject.Name);
					}
					else
					{ 
						navLink.InnerHtml = HttpUtility.HtmlEncode(objMcmsObject.DisplayName);
					}

					//Add URL to Channel - use flexible URL instead of mode specific
					navLink.HRef = objMcmsObject.Url;
					cell = new System.Web.UI.WebControls.TableCell();
					cell.Controls.Add(navLink);
					cell.Wrap = false;
					row.Cells.Add(cell);

					//Create a row for the placeholder summary
					row = new System.Web.UI.WebControls.TableRow();
					table.Rows.Add(row);
					cell = new System.Web.UI.WebControls.TableCell();
					string PlaceholderName = McmsPhName.ToString();

					HtmlPlaceholder phTitle;
					//Add user defined option for summary info from a placholder
					if(PlaceholderName.Length > 0)
					{ 
						try
						{
							phTitle = (HtmlPlaceholder)objMcmsObject.Placeholders[PlaceholderName];
						}
						catch
						{
							return table; //Early return
						}

						//Error check for null placeholder
						if(phTitle != null)
						{
							//Allow user to specify how many characters to show 
							if(phTitle.Text.Length > CharactersToShow)
							{
								cell.Text = phTitle.Text.Substring(0, CharactersToShow);
							}
							else
							{
								cell.Text = phTitle.Text;
							}
							cell.Wrap = false;
						}
					}
				
					//Add placeholder contents to the page
					row.Cells.Add(cell);
				}	
			}
			return table;

		} //Close PopulateNavigationTable

		/// <summary> 
		/// Render this control to the output parameter specified.
		/// </summary>
		/// <param name="output"> The HTML writer to write out to </param>
		protected override void Render(HtmlTextWriter output)
		{
			//Call base class
			base.Render(output);		
		}

		#endregion Private functions


	} //Close Control Class
} //Close Namespace
//EOF - SC - March 2002